package org.msh.tb.bd.tbforms.indicator.tb10;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.bd.tbforms.query.tb10.TBForm10Block6CQuery;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.enums.TbFormField;
import org.msh.tb.indicators.core.Indicator2D;

import java.util.List;
import java.util.Map;

@Name("TBForm10Block6C")
public class TBForm10Block6C extends Indicator2D {

    TbFormQuery formQuery;

    @In(create=true) protected Map<String, String> messages;

	@Override
	protected void createIndicators() {
        initializeInterfaceTableRow();

        Tbunit tbunit = getIndicatorFilters().getTbunitselection().getSelected();
        AdministrativeUnit adminUnit = getIndicatorFilters().getTbunitselection().getLastLevelAdminUnitSelected();

        List<Object[]> result = getFormQuery().queryDB(tbunit,
                adminUnit,
                getWorkspace(),
                getIndicatorFilters().getQuarter(),
                getEntityManager());

        for(Object[] o : result) {
            TbFormField field = (TbFormField) o[0];
            Integer qtd = (Integer) o[1];

            switch (field) {
                case TB10_BLOCK6C_FIELD1:
                    addValue("M", "nodisplayname_line1", qtd.floatValue());
                    addValue(messages.get("global.total"), "nodisplayname_line1", qtd.floatValue());
                    break;
                case TB10_BLOCK6C_FIELD2:
                    addValue("F", "nodisplayname_line1", qtd.floatValue());
                    addValue(messages.get("global.total"), "nodisplayname_line1", qtd.floatValue());
                    break;
            }
        }
	}

    /**
     * Initialize the interface table. All cells should be there also if it's result is zero.
     */
    private void initializeInterfaceTableRow(){
        addValue("M", "nodisplayname_line1", new Float(0).floatValue());
        addValue("F", "nodisplayname_line1", new Float(0).floatValue());
        addValue(messages.get("global.total"), "nodisplayname_line1", new Float(0).floatValue());
    }

    private TbFormQuery getFormQuery() {
        if (formQuery == null) {
            formQuery = new TBForm10Block6CQuery();
        }

        return formQuery;
    }
}
